/***********************************************************************/
/*  This file is part of the ARM Toolchain package                     */
/*  Copyright KEIL ELEKTRONIK GmbH 2003 - 2010                         */
/***********************************************************************/
/*                                                                     */
/*  FlashDev.C:  Flash Programming Functions adapted                   */
/*               for ES32W3120 IROM           				           */
/*                                                                     */
/***********************************************************************/


#include "ald_conf.h"
#include "flm_qspi.h"
#include "w25q128fv.h"

#ifdef OutputDebugInfo
    #include "debugModule.h"
#endif


/* Exported Types ---------------------------------------------------------- */

/* Exported Macros ----------------------------------------------------------- */

#define QSPI_PORT0      GPIOB
#define QSPI_PORT1      GPIOD
#define QSPI_NSS0_PIN   GPIO_PIN_12
#define QSPI_SCK_PIN    GPIO_PIN_13
#define QSPI_IO0_PIN    GPIO_PIN_14
#define QSPI_IO1_PIN    GPIO_PIN_15
#define QSPI_IO2_PIN    GPIO_PIN_8
#define QSPI_IO3_PIN    GPIO_PIN_9

/* Exported Variables -------------------------------------------------------- */
extern qspi_dac_cfg_t g_dac;
extern qspi_handle_t g_qspi;
extern qspi_data_capture_cfg_t g_capture_cfg;

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */
void config_flash_param(qspi_handle_t *g_qspi);
void qspi_pin_init(void);
ald_status_t bsp_w25q128_reset(void);
ald_status_t bsp_w25q128_wr_enable(void);
ald_status_t bsp_w25q128_enable_quad_mode(void);
ald_status_t bsp_w25q128_disable_protect(void);
ald_status_t bsp_w25q128_erase_block(uint32_t blkaddr);
ald_status_t bsp_w25q128_erase_chip(void);

